gpu_set_blendenable(false);

// Check if the menu is active
if (menu_active) {
    // Pause the game while the menu is active
    if (!pause) {
        pause = true;
        instance_deactivate_all(true);  // Deactivate all objects except persistent ones
        instance_activate_object(self); // Keep oPowerSelect active
    }

    // Input handling for menu navigation
    var up_key = keyboard_check_pressed(vk_up);
    var down_key = keyboard_check_pressed(vk_down);
    var accept_key = keyboard_check_pressed(vk_enter);

    // Navigate the menu
    pos += down_key - up_key;
    if (pos >= op_length) pos = 0;
    if (pos < 0) pos = op_length - 1;

    // Select the current option
    if (accept_key) {
        global.powerUps[pos] = 1;  // Mark the selected power-up as collected

        // Apply the selected power-up
        if (pos == 0) { // Jump Boost
            global.jspd[0] = -10; // Apply jump boost
        } else if (pos == 1) { // Double Speed
            global.moveSpd *= 2;  // Double the movement speed
        }
        // Add additional cases for more power-ups if needed

        // Unpause the game and deactivate the menu
        instance_activate_all(); // Reactivate all objects
        instance_destroy();      // Destroy the orb
    }

    // Play navigation sound if position changes
    if (pos != last_selected) {
        audio_play_sound(select, 1, false);
        last_selected = pos;
    }
} else {
    // Activate the menu when the player collects the orb
    if (instance_exists(global.player_instance) && place_meeting(x, y, global.player_instance)) {
        menu_active = true;
    }
}

gpu_set_blendenable(true);
